unit uDSOTest;

interface

uses
  SysUtils, Classes, HTTPApp, WebModu, HTTPProd, ReqMulti, WebDisp,
  WebAdapt, WebComp;

type
  TPageProducerActiveDelphi = class(TWebAppPageModule)
    PageProducer: TPageProducer;
    WebAppComponents: TWebAppComponents;
    ApplicationAdapter: TApplicationAdapter;
    PageDispatcher: TPageDispatcher;
    AdapterDispatcher: TAdapterDispatcher;
    procedure WebAppComponentsAfterDispatch(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  function PageProducerActiveDelphi: TPageProducerActiveDelphi;

implementation

{$R *.xfm}  {*.html}

uses WebReq, WebCntxt, WebFact, Variants;

function PageProducerActiveDelphi: TPageProducerActiveDelphi;
begin
  Result := TPageProducerActiveDelphi(WebContext.FindModuleClass(TPageProducerActiveDelphi));
end;

procedure TPageProducerActiveDelphi.WebAppComponentsAfterDispatch(
  Sender: TObject; Request: TWebRequest; Response: TWebResponse;
  var Handled: Boolean);
begin
  Response.Content := '<H1>Bem vindo ao "Mundo" ActiveDelphi.</H1>';
end;

initialization
  if WebRequestHandler <> nil then
    WebRequestHandler.AddWebModuleFactory(TWebAppPageModuleFactory.Create(TPageProducerActiveDelphi, TWebPageInfo.Create([wpPublished {, wpLoginRequired}], '.html'), caCache));
end.

